#pragma once

#include "QQUser.h"
#include "QQProtocol.h"
#include "ThreadPool.h"
#include "SendMsgTask.h"
#include "RecvMsgTask.h"
#include "PollTask.h"
#include "QQNumTask.h"
#include "QQSignTask.h"
#include "GetHeadPicTask.h"

class CLoginTask : public CThreadPoolTask
{
public:
	CLoginTask(void);
	~CLoginTask(void);

public:
	virtual int Run();
	virtual int Stop();
	virtual void TaskFinish();

private:
	CBuddyInfoResult * GetUserInfo();			// ȡûϢ
	CGetSignResult * GetUserSign();				// ȡûǩ
	CBuddyListResult * GetBuddyList();			// ȡб
	CGroupListResult * GetGroupList();			// ȡȺб
	CRecentListResult * GetRecentList();		// ȡϵб
	BOOL StartSendMsgTask();					// Ϣ
	BOOL StartRecvMsgTask();					// Ϣ
	BOOL StartPollTask();						// ѯ
	BOOL StartGetBuddyNumberTask(CBuddyListResult * lpBuddyListResult, 
		CGroupListResult * lpGroupListResult);	// ȡQQ
	BOOL StartGetBuddySignTask(CBuddyListResult * lpBuddyListResult);	// ȡQQǩ
	BOOL StartGetHeadPicTask(CBuddyListResult * lpBuddyListResult, 
		CGroupListResult * lpGroupListResult);	// ȡͷͼƬ

public:
	CQQUser * m_lpQQUser;
	CQQProtocol * m_lpQQProtocol;
	CThreadPool * m_lpThreadPool;
	CSendMsgTask * m_lpSendMsgTask;
	CRecvMsgTask * m_lpRecvMsgTask;
	CPollTask * m_lpPollTask;
	
private:
	BOOL m_bStop;
	CHttpClient m_HttpClient;
};
